unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  ImgList, StdCtrls, ComCtrls, Shellapi, MD5;

type
  TfrmMain = class(TForm)
    btnCheck: TButton;
    edtPath: TEdit;
    btnBrowse: TButton;
    opndlgWadFile: TOpenDialog;
    grpResult: TGroupBox;
    grpParam: TGroupBox;
    ImageList1: TImageList;
    lstGame: TListView;
    sttGame: TStaticText;
    lstVersion: TListView;
    sttVersion: TStaticText;
    sttUrl: TStaticText;
    procedure btnCheckClick(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure sttUrlClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

const
 DoomS19 : String = 'f0cefca49926d00903cf57551d901abe';
 Doom11 : String = '981b03e6d1dc033301aa3095acc437ce';
 Doom12 : String = '792fd1fea023d61210857089a7c1e351';
 Doom1666 : String = '54978d12de87f162b9bcc011676cb3c0';
 Doom19r : String = '1cd63c5ddff1bf8ce844237f580e9cf3';
 uDoom19 : String = 'c4fe9fd920207691a9f493668e0a2083';
 Doom219 : String = '25e1459ca71d321525f84628f45ca8cd';
 TNT : String = '4e158d9953c79ccf97bd0663244cc6b6';
 Plutonia : String = '75c8cf89566741fa9d22447604053bd7';
 HereticR : String = '66d686b1ed6d35ff103f15dbd30e0341';
 Hexen11R : String = 'abb033caf81e26f12a2103e1fa25453f';
 HexenDD : String = '1077432e2690d390c256ac908b5f4efa';
 StrifeR : String = '2fed2031a5b03892106e0f117f17901f'; // Strife 1.2, 1.3 or 1.31 registered

implementation

{$R *.dfm}

procedure TfrmMain.btnCheckClick(Sender: TObject);
var
 md5result : string;
begin
 if frmMain.edtPath.Text <> '' then
 begin
  frmMain.lstGame.Items.Item[0].ImageIndex := 1;
  frmMain.lstGame.Items.Item[1].ImageIndex := 1;
  frmMain.lstGame.Items.Item[2].ImageIndex := 1;
  frmMain.lstGame.Items.Item[3].ImageIndex := 1;
  frmMain.lstGame.Items.Item[4].ImageIndex := 1;
  frmMain.lstGame.Items.Item[5].ImageIndex := 1;
  frmMain.lstGame.Items.Item[6].ImageIndex := 1;
  frmMain.lstGame.Items.Item[7].ImageIndex := 1;
  frmMain.lstGame.Items.Item[8].ImageIndex := 1;
  frmMain.lstGame.Items.Item[9].ImageIndex := 1;
  frmMain.lstVersion.Items.Item[0].ImageIndex := 1;
  frmMain.lstVersion.Items.Item[1].ImageIndex := 1;
  frmMain.lstVersion.Items.Item[2].ImageIndex := 1;
  frmMain.lstVersion.Items.Item[3].ImageIndex := 1;
  frmMain.lstVersion.Items.Item[4].ImageIndex := 1;
  frmMain.lstVersion.Items.Item[5].ImageIndex := 1;
  frmMain.lstVersion.Items.Item[6].ImageIndex := 1;

  md5result := MD5.FileMD5(frmMain.edtPath.Text);
  if AnsiCompareText(md5result, DoomS19) = 0 then
   begin
    frmMain.lstGame.Items.Item[0].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[6].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, Doom11) = 0 then
   begin
    frmMain.lstGame.Items.Item[1].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[1].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, Doom12) = 0 then
   begin
    frmMain.lstGame.Items.Item[1].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[2].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, Doom1666) = 0 then
   begin
    frmMain.lstGame.Items.Item[1].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[5].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, Doom19r) = 0 then
   begin
    frmMain.lstGame.Items.Item[1].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[6].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, uDoom19) = 0 then
   begin
    frmMain.lstGame.Items.Item[2].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[6].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, Doom219) = 0 then
   begin
    frmMain.lstGame.Items.Item[3].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[6].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, TNT) = 0 then
   begin
    frmMain.lstGame.Items.Item[4].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[6].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, Plutonia) = 0 then
   begin
    frmMain.lstGame.Items.Item[5].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[6].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, HereticR) = 0 then
   begin
    frmMain.lstGame.Items.Item[6].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[3].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, Hexen11R) = 0 then
   begin
    frmMain.lstGame.Items.Item[7].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[1].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, HexenDD) = 0 then
   begin
    frmMain.lstGame.Items.Item[8].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, StrifeR) = 0 then
   begin
    frmMain.lstGame.Items.Item[9].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[2].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[3].ImageIndex := 0;
    frmMain.lstVersion.Items.Item[4].ImageIndex := 0;
   end
  else if AnsiCompareText(md5result, '') > 0 then // this is a nasty hack, I know.
   begin
    ShowMessage('NOT a valid IWAD file' + #13 +
                'Which could have one or more of the following reasons for this:' + #13 +
                '1: The file has been modified by another program' + #13 +
                '2: It is of an older version of what is supported by this program' + #13 +
                '3: Bad file size' + #13 +
                '4: An unsupported IWAD file (such as freedoom or freedm)');
   end;
 end;
end;

procedure TfrmMain.btnBrowseClick(Sender: TObject);
begin
 frmMain.opndlgWadFile.Execute;
 frmMain.edtPath.Text := '';
 frmMain.lstGame.Items.Item[0].ImageIndex := 1;
 frmMain.lstGame.Items.Item[1].ImageIndex := 1;
 frmMain.lstGame.Items.Item[2].ImageIndex := 1;
 frmMain.lstGame.Items.Item[3].ImageIndex := 1;
 frmMain.lstGame.Items.Item[4].ImageIndex := 1;
 frmMain.lstGame.Items.Item[5].ImageIndex := 1;
 frmMain.lstGame.Items.Item[6].ImageIndex := 1;
 frmMain.lstGame.Items.Item[7].ImageIndex := 1;
 frmMain.lstGame.Items.Item[8].ImageIndex := 1;
 frmMain.lstGame.Items.Item[9].ImageIndex := 1;
 frmMain.lstVersion.Items.Item[0].ImageIndex := 1;
 frmMain.lstVersion.Items.Item[1].ImageIndex := 1;
 frmMain.lstVersion.Items.Item[2].ImageIndex := 1;
 frmMain.lstVersion.Items.Item[3].ImageIndex := 1;
 frmMain.lstVersion.Items.Item[4].ImageIndex := 1;
 frmMain.lstVersion.Items.Item[5].ImageIndex := 1;
 frmMain.lstVersion.Items.Item[6].ImageIndex := 1;
 if frmMain.opndlgWadFile.FileName <> '' then frmMain.edtPath.Text := frmMain.opndlgWadFile.FileName;
end;

procedure TfrmMain.sttUrlClick(Sender: TObject);
begin
 ShellExecute(0, 'open', 'http://russell.slipgate.org', nil, nil, 0);
end;

end.
